/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.live.field;

import org.openzen.entitysyncer.live.LiveObject;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.definition.ObjectFieldType;
import org.openzen.entitysyncer.structured.definition.StructuredFieldType;

/**
 *
 * @author Hoofdgebruiker
 */
public class LiveObjectField<T extends StructuredObject> extends LiveBaseField implements LiveField, LiveObject<T> {
	private final ObjectFieldType type;
	private T value;
	
	public LiveObjectField(T value, ObjectFieldType type) {
		this.value = value;
		this.type = type;
	}
	
	@Override
	public T get() {
		return value;
	}
	
	@Override
	public void set(T value) {
		this.value = value;
		publish();
	}
	
	@Override
	public void setUnsafe(StructuredObject value) {
		// TODO: add type safety here
		set((T) value);
	}
	
	@Override
	public void clear() {
		set(null);
	}
	
	@Override
	public StructuredFieldType getType() {
		return type;
	}

	@Override
	public LiveObject<?> asObject() {
		return this;
	}

	@Override
	public StructuredObject asObjectValue() {
		return value;
	}
}
