/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.live.field;

import java.util.UUID;
import org.openzen.entitysyncer.live.LiveObject;
import org.openzen.entitysyncer.live.LiveString;
import org.openzen.entitysyncer.live.LiveUUID;
import org.openzen.entitysyncer.live.LiveUUIDFunction;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.definition.StringFieldType;
import org.openzen.entitysyncer.structured.definition.StructuredFieldType;

/**
 *
 * @author Hoofdgebruiker
 */
public class LiveStringField extends LiveBaseNumberField implements LiveString {
	private String value;
	
	public LiveStringField(String value) {
		this.value = value;
	}
	
	@Override
	public void clear() {
		set("");
	}
	
	@Override
	public StructuredFieldType getType() {
		return StringFieldType.INSTANCE;
	}
	
	@Override
	public String get() {
		return value;
	}
	
	public void set(String value) {
		this.value = value;
		publish();
	}
	
	@Override
	public boolean asBoolValue() {
		return Boolean.parseBoolean(value);
	}
	
	@Override
	public int asIntValue() {
		return Integer.parseInt(value);
	}
	
	@Override
	public long asLongValue() {
		return Long.parseLong(value);
	}

	@Override
	public float asFloatValue() {
		return Float.parseFloat(value);
	}
	
	@Override
	public double asDoubleValue() {
		return Double.parseDouble(value);
	}

	@Override
	public LiveString asString() {
		return this;
	}
	
	@Override
	public String asStringValue() {
		return value;
	}
	
	@Override
	public LiveUUID asUUID() {
		return new LiveUUIDFunction(this::asUUIDValue, this);
	}
	
	@Override
	public UUID asUUIDValue() {
		return UUID.fromString(value);
	}

	@Override
	public LiveObject<?> asObject() {
		throw new ClassCastException("Cannot convert a string to an object");
	}
	
	@Override
	public StructuredObject asObjectValue() {
		throw new ClassCastException("Cannot convert a string to an object");
	}
}
