/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.commit;

import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.live.field.LiveField;

/**
 *
 * @author Hoofdgebruiker
 */
public class SetIntFieldOperation extends StructuredSetOperation {
	private final int value;
	
	public SetIntFieldOperation(int object, int field, int value) {
		super(object, field);
		
		this.value = value;
	}
	
	public SetIntFieldOperation(StructuredDataInputStream input) {
		super(input);
		
		value = input.input.readVarInt();
	}

	@Override
	protected void apply(LiveField field) {
		field.asInt().set(value);
	}
}
