/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.definition;

import org.openzen.entitysyncer.live.any.LiveAny;
import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredDataOutputStream;
import org.openzen.entitysyncer.live.field.LiveField;
import org.openzen.entitysyncer.live.field.LiveIntField;

/**
 *
 * @author Hoofdgebruiker
 */
public class IntFieldType implements StructuredFieldType {
	public static final IntFieldType INSTANCE = new IntFieldType();
	
	private IntFieldType() {}

	@Override
	public LiveField create() {
		return new LiveIntField(0);
	}

	@Override
	public void serialize(StructuredDataOutputStream output) {
		output.output.writeVarUInt(TYPE_INT);
	}

	@Override
	public void read(LiveField field, StructuredDataInputStream input) {
		field.asInt().set(input.input.readInt());
	}

	@Override
	public void write(StructuredDataOutputStream output, LiveAny value) {
		output.output.writeInt(value.asIntValue());
	}
}
