/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.live.field;

import org.openzen.entitysyncer.live.LiveBool;
import org.openzen.entitysyncer.live.LiveObject;
import org.openzen.entitysyncer.live.field.LiveBaseNumberField;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.definition.BoolFieldType;
import org.openzen.entitysyncer.structured.definition.StructuredFieldType;

public class LiveBoolField
extends LiveBaseNumberField
implements LiveBool {
    private boolean value;

    public LiveBoolField(boolean value) {
        this.value = value;
    }

    @Override
    public boolean get() {
        return this.value;
    }

    @Override
    public void set(boolean value) {
        this.value = value;
        this.publish();
    }

    @Override
    public void clear() {
        this.set(false);
    }

    @Override
    public StructuredFieldType getType() {
        return BoolFieldType.INSTANCE;
    }

    @Override
    public LiveBool asBool() {
        return this;
    }

    @Override
    public boolean asBoolValue() {
        return this.value;
    }

    @Override
    public int asIntValue() {
        return this.value ? 1 : 0;
    }

    @Override
    public long asLongValue() {
        return this.asIntValue();
    }

    @Override
    public float asFloatValue() {
        return this.asIntValue();
    }

    @Override
    public double asDoubleValue() {
        return this.asIntValue();
    }

    @Override
    public String asStringValue() {
        return Boolean.toString(this.value);
    }

    @Override
    public LiveObject<?> asObject() {
        throw new ClassCastException("Cannot convert a boolean to an object");
    }

    @Override
    public StructuredObject asObjectValue() {
        throw new ClassCastException("Cannot convert a boolean to an object");
    }
}

