/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.live.field;

import org.openzen.entitysyncer.live.LiveDouble;
import org.openzen.entitysyncer.live.LiveDoubleFunction;
import org.openzen.entitysyncer.live.LiveFloat;
import org.openzen.entitysyncer.live.LiveLong;
import org.openzen.entitysyncer.live.LiveLongFunction;
import org.openzen.entitysyncer.live.field.LiveBaseNumberField;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.definition.FloatFieldType;
import org.openzen.entitysyncer.structured.definition.StructuredFieldType;

public class LiveFloatField
extends LiveBaseNumberField
implements LiveFloat {
    private float value;

    public LiveFloatField(float value) {
        this.value = value;
    }

    @Override
    public float get() {
        return this.value;
    }

    @Override
    public void set(float value) {
        this.value = value;
        this.publish();
    }

    @Override
    public void clear() {
        this.set(0.0f);
    }

    @Override
    public StructuredFieldType getType() {
        return FloatFieldType.INSTANCE;
    }

    @Override
    public boolean asBoolValue() {
        return this.value != 0.0f;
    }

    @Override
    public int asIntValue() {
        return (int)this.value;
    }

    @Override
    public LiveLong asLong() {
        return new LiveLongFunction(() -> (long)this.value, v -> this.set(this.value), this);
    }

    @Override
    public long asLongValue() {
        return (long)this.value;
    }

    @Override
    public LiveFloat asFloat() {
        return this;
    }

    @Override
    public float asFloatValue() {
        return this.value;
    }

    @Override
    public LiveDouble asDouble() {
        return new LiveDoubleFunction(() -> this.value, v -> this.set((float)v), this);
    }

    @Override
    public double asDoubleValue() {
        return this.value;
    }

    @Override
    public String asStringValue() {
        return Float.toString(this.value);
    }

    @Override
    public StructuredObject asObjectValue() {
        throw new ClassCastException("Cannot cast int to an object");
    }
}

