/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.structured;

import java.util.List;
import org.openzen.entitysyncer.live.field.LiveField;
import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.definition.StructuredFieldDefinition;
import org.openzen.entitysyncer.structured.definition.StructuredObjectClass;

public class StructuredGenericObject
implements StructuredObject {
    private final StructuredObject baseObject;
    private final StructuredObjectClass cls;
    private List<LiveField> fields;

    public StructuredGenericObject(StructuredObject baseObject, StructuredObjectClass cls, StructuredDataInputStream input) {
        this.baseObject = baseObject;
        this.cls = cls;
        for (StructuredFieldDefinition field : cls.getFields()) {
            while (field.id <= this.fields.size()) {
                this.fields.add(null);
            }
            this.fields.set(field.id, field.type.create());
        }
        long fieldsMask = input.input.readVarULong();
        int index = 0;
        for (StructuredFieldDefinition field : cls.getFields()) {
            long fieldMask = 1L << index;
            if ((fieldsMask & fieldMask) > 0L) {
                fieldsMask &= fieldMask ^ 0xFFFFFFFFFFFFFFFFL;
                field.type.read(this.fields.get(field.id), input);
            }
            ++index;
        }
        if (fieldsMask != 0L) {
            throw new RuntimeException("Illegal object: one or more fields were not deserialized");
        }
    }

    @Override
    public StructuredObjectClass getStructuredClass() {
        return this.cls;
    }

    @Override
    public StructuredObject getBaseObject() {
        return this.baseObject;
    }

    @Override
    public LiveField getField(int index) {
        return this.fields.get(index);
    }

    @Override
    public <T extends StructuredObject> T as(Class<T> cls) {
        return this.baseObject == null ? null : (T)this.baseObject.as(cls);
    }
}

