/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.structured.definition;

import java.util.UUID;
import org.openzen.entitysyncer.live.any.LiveAny;
import org.openzen.entitysyncer.live.field.LiveField;
import org.openzen.entitysyncer.live.field.LiveUUIDField;
import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredDataOutputStream;
import org.openzen.entitysyncer.structured.definition.StructuredFieldType;

public class UUIDFieldType
implements StructuredFieldType {
    public static final UUIDFieldType INSTANCE = new UUIDFieldType();
    public static final UUID NULL = new UUID(0L, 0L);

    private UUIDFieldType() {
    }

    @Override
    public LiveField create() {
        return new LiveUUIDField(NULL);
    }

    @Override
    public void serialize(StructuredDataOutputStream output) {
        output.output.writeVarUInt(8);
    }

    @Override
    public void read(LiveField field, StructuredDataInputStream input) {
        field.asUUID().set(input.input.readUUID());
    }

    @Override
    public void write(StructuredDataOutputStream output, LiveAny value) {
        output.output.writeUUID(value.asUUIDValue());
    }
}

