package org.openzen.packetstreams;

import org.libsodium.jni.keys.KeyPair;
import org.libsodium.jni.keys.VerifyKey;
import org.openzen.packetstreams.crypto.CryptoKeyPair;
import org.openzen.packetstreams.crypto.CryptoPrivateKey;
import org.openzen.packetstreams.crypto.CryptoProvider;
import org.openzen.packetstreams.crypto.CryptoPublicKey;
import org.openzen.packetstreams.crypto.CryptoSharedKey;
import org.openzen.packetstreams.crypto.CryptoSigningKey;
import org.openzen.packetstreams.crypto.CryptoVerifyKey;

/**
 * Created by Hoofdgebruiker on 5/01/2019.
 */

public class AndroidCrypto implements CryptoProvider {
    public static final AndroidCrypto INSTANCE = new AndroidCrypto();

    private AndroidCrypto() {}

    @Override
    public CryptoPrivateKey decodePrivateKey(byte[] data) {
        return new AndroidCryptoPrivateKey(data);
    }

    @Override
    public CryptoPublicKey decodePublicKey(byte[] data) {
        return new AndroidCryptoPublicKey(data);
    }

    @Override
    public CryptoSigningKey decodeSigningKey(byte[] data) {
        return new AndroidCryptoSigningKey(data);
    }

    @Override
    public CryptoSigningKey generateSigningKey() {
        return new AndroidCryptoSigningKey();
    }

    @Override
    public CryptoVerifyKey decodeVerifyKey(byte[] data) {
        return new AndroidCryptoVerifyKey(new VerifyKey(data));
    }

    @Override
    public CryptoSharedKey createSharedKey(CryptoPublicKey publicKey, CryptoPrivateKey privateKey) {
        return new AndroidCryptoSharedKey(publicKey, privateKey);
    }

    @Override
    public CryptoKeyPair generateKeyPair() {
        KeyPair keyPair = new KeyPair();
        return new CryptoKeyPair(
                new AndroidCryptoPrivateKey(keyPair.getPrivateKey()),
                new AndroidCryptoPublicKey(keyPair.getPublicKey()));
    }

    @Override
    public byte[] generateNonce() {
        return new byte[0];
    }
}
