package org.openzen.packetstreams;

import org.libsodium.jni.keys.PrivateKey;
import org.openzen.packetstreams.crypto.CryptoPrivateKey;

public class AndroidCryptoPrivateKey implements CryptoPrivateKey {
    private final PrivateKey privateKey;

    public AndroidCryptoPrivateKey(PrivateKey key) {
        privateKey = key;
    }

    public AndroidCryptoPrivateKey(byte[] data) {
        privateKey = new PrivateKey(data);
    }

    @Override
    public byte[] encode() {
        return privateKey.toBytes();
    }
}
