package org.openzen.packetstreams;

import org.libsodium.jni.keys.PublicKey;
import org.openzen.packetstreams.crypto.CryptoPublicKey;

public class AndroidCryptoPublicKey implements CryptoPublicKey {
    public final PublicKey publicKey;

    public AndroidCryptoPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public AndroidCryptoPublicKey(byte[] data) {
        publicKey = new PublicKey(data);
    }

    @Override
    public byte[] encode() {
        return publicKey.toBytes();
    }
}
