package org.openzen.packetstreams;

import org.libsodium.jni.crypto.Box;
import org.openzen.packetstreams.crypto.CryptoDecryptionException;
import org.openzen.packetstreams.crypto.CryptoPrivateKey;
import org.openzen.packetstreams.crypto.CryptoPublicKey;
import org.openzen.packetstreams.crypto.CryptoSharedKey;

import java.util.Arrays;

/**
 *
 * @author Hoofdgebruiker
 */
public class AndroidCryptoSharedKey implements CryptoSharedKey {
    private final Box box;

    public AndroidCryptoSharedKey(CryptoPublicKey publicKey, CryptoPrivateKey privateKey) {
        box = new Box(publicKey.encode(), privateKey.encode());
    }

    @Override
    public byte[] decrypt(byte[] nonce, byte[] message) throws CryptoDecryptionException {
        try {
            return box.decrypt(nonce, message);
        } catch (RuntimeException ex) {
            throw new CryptoDecryptionException();
        }
    }

    @Override
    public byte[] encrypt(byte[] nonce, byte[] message) {
        return box.encrypt(nonce, message);
    }
}
