package org.openzen.packetstreams;

import org.libsodium.jni.keys.SigningKey;
import org.openzen.packetstreams.crypto.CryptoSigningKey;
import org.openzen.packetstreams.crypto.CryptoVerifyKey;

/**
 *
 * @author Hoofdgebruiker
 */
public class AndroidCryptoSigningKey implements CryptoSigningKey {
    private final SigningKey signingKey;

    public AndroidCryptoSigningKey() {
        signingKey = new SigningKey();
    }

    public AndroidCryptoSigningKey(byte[] data) {
        signingKey = new SigningKey(data);
    }

    @Override
    public CryptoVerifyKey getVerifyKey() {
        return new AndroidCryptoVerifyKey(signingKey.getVerifyKey());
    }

    @Override
    public byte[] encode() {
        return signingKey.toBytes();
    }

    @Override
    public byte[] sign(byte[] message) {
        return signingKey.sign(message);
    }
}
