package org.openzen.packetstreams;

import org.libsodium.jni.keys.VerifyKey;
import org.openzen.packetstreams.crypto.CryptoVerifyKey;

/**
 *
 * @author Hoofdgebruiker
 */
public class AndroidCryptoVerifyKey implements CryptoVerifyKey {
    private final VerifyKey verifyKey;

    public AndroidCryptoVerifyKey(VerifyKey verifyKey) {
        this.verifyKey = verifyKey;
    }

    @Override
    public byte[] encode() {
        return verifyKey.toBytes();
    }

    @Override
    public boolean verify(byte[] message, byte[] signature) {
        return verifyKey.verify(message, signature);
    }
}
