/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.javacrypto;

import org.openzen.packetstreams.crypto.CryptoKeyPair;
import org.openzen.packetstreams.crypto.CryptoPrivateKey;
import org.openzen.packetstreams.crypto.CryptoPublicKey;
import org.openzen.packetstreams.crypto.CryptoSharedKey;
import org.openzen.packetstreams.crypto.CryptoSigningKey;
import org.openzen.packetstreams.crypto.CryptoVerifyKey;
import org.openzen.packetstreams.crypto.PacketStreamsCrypto;
import org.openzen.packetstreams.javacrypto.JavaCryptoPrivateKey;
import org.openzen.packetstreams.javacrypto.JavaCryptoPublicKey;
import org.openzen.packetstreams.javacrypto.JavaCryptoSharedKey;
import org.openzen.packetstreams.javacrypto.JavaCryptoSigningKey;
import org.openzen.packetstreams.javacrypto.JavaCryptoVerifyKey;
import org.openzen.saltpot.crypto.Random;
import org.openzen.saltpot.keys.KeyPair;
import org.openzen.saltpot.keys.VerifyKey;

public class JavaCrypto
implements PacketStreamsCrypto {
    public static final JavaCrypto INSTANCE = new JavaCrypto();

    private JavaCrypto() {
    }

    public CryptoPrivateKey decodePrivateKey(byte[] data) {
        return new JavaCryptoPrivateKey(data);
    }

    public CryptoPublicKey decodePublicKey(byte[] data) {
        return new JavaCryptoPublicKey(data);
    }

    public CryptoSigningKey decodeSigningKey(byte[] data) {
        return new JavaCryptoSigningKey(data);
    }

    public CryptoSigningKey generateSigningKey() {
        return new JavaCryptoSigningKey();
    }

    public CryptoVerifyKey decodeVerifyKey(byte[] data) {
        return new JavaCryptoVerifyKey(new VerifyKey(data));
    }

    public CryptoSharedKey createSharedKey(CryptoPublicKey publicKey, CryptoPrivateKey privateKey) {
        return new JavaCryptoSharedKey(publicKey, privateKey);
    }

    public CryptoKeyPair generateKeyPair() {
        KeyPair keyPair = new KeyPair();
        return new CryptoKeyPair((CryptoPrivateKey)new JavaCryptoPrivateKey(keyPair.getPrivateKey()), (CryptoPublicKey)new JavaCryptoPublicKey(keyPair.getPublicKey()));
    }

    public byte[] generateNonce() {
        return new Random().randomBytes(24);
    }
}

