/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.javacrypto;

import java.util.Arrays;
import org.openzen.packetstreams.crypto.CryptoDecryptionException;
import org.openzen.packetstreams.crypto.CryptoPrivateKey;
import org.openzen.packetstreams.crypto.CryptoPublicKey;
import org.openzen.packetstreams.crypto.CryptoSharedKey;
import org.openzen.saltpot.crypto.Box;

public class JavaCryptoSharedKey
implements CryptoSharedKey {
    private final Box box;

    public JavaCryptoSharedKey(CryptoPublicKey publicKey, CryptoPrivateKey privateKey) {
        this.box = new Box(publicKey.encode(), privateKey.encode());
    }

    public byte[] decrypt(byte[] nonce, byte[] message, int offset, int length) throws CryptoDecryptionException {
        byte[] copy = offset == 0 && length == message.length ? message : Arrays.copyOfRange(message, offset, offset + length);
        try {
            return this.box.decrypt(nonce, copy);
        }
        catch (RuntimeException ex) {
            throw new CryptoDecryptionException();
        }
    }

    public byte[] encrypt(byte[] nonce, byte[] message, int offset, int length) {
        byte[] copy = offset == 0 && length == message.length ? message : Arrays.copyOfRange(message, offset, offset + length);
        return this.box.encrypt(nonce, copy);
    }
}

