/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.packetstreams.javacrypto;

import org.openzen.packetstreams.crypto.CryptoSigningKey;
import org.openzen.packetstreams.crypto.CryptoVerifyKey;
import org.openzen.saltpot.keys.SigningKey;

/**
 *
 * @author Hoofdgebruiker
 */
public class JavaCryptoSigningKey implements CryptoSigningKey {
	private final SigningKey signingKey;
	
	public JavaCryptoSigningKey() {
		signingKey = new SigningKey();
	}
	
	public JavaCryptoSigningKey(byte[] data) {
		signingKey = new SigningKey(data);
	}

	@Override
	public CryptoVerifyKey getVerifyKey() {
		return new JavaCryptoVerifyKey(signingKey.getVerifyKey());
	}

	@Override
	public byte[] encode() {
		return signingKey.toBytes();
	}

	@Override
	public byte[] sign(byte[] message) {
		return signingKey.sign(message);
	}
}
