/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.packetstreams.javacrypto;

import org.openzen.packetstreams.crypto.CryptoKeyPair;
import org.openzen.packetstreams.crypto.CryptoPrivateKey;
import org.openzen.packetstreams.crypto.CryptoPublicKey;
import org.openzen.packetstreams.crypto.CryptoSharedKey;
import org.openzen.packetstreams.crypto.CryptoSigningKey;
import org.openzen.packetstreams.crypto.CryptoVerifyKey;
import static org.openzen.packetstreams.crypto.CryptoProvider.NONCE_BYTES;
import org.openzen.saltpot.crypto.Random;
import org.openzen.saltpot.keys.KeyPair;
import org.openzen.saltpot.keys.VerifyKey;
import org.openzen.packetstreams.crypto.CryptoProvider;

/**
 *
 * @author Hoofdgebruiker
 */
public class JavaCrypto implements CryptoProvider {
	public static final JavaCrypto INSTANCE = new JavaCrypto();
	
	private JavaCrypto() {}

	@Override
	public CryptoPrivateKey decodePrivateKey(byte[] data) {
		return new JavaCryptoPrivateKey(data);
	}

	@Override
	public CryptoPublicKey decodePublicKey(byte[] data) {
		return new JavaCryptoPublicKey(data);
	}

	@Override
	public CryptoSigningKey decodeSigningKey(byte[] data) {
		return new JavaCryptoSigningKey(data);
	}

	@Override
	public CryptoSigningKey generateSigningKey() {
		return new JavaCryptoSigningKey();
	}

	@Override
	public CryptoVerifyKey decodeVerifyKey(byte[] data) {
		return new JavaCryptoVerifyKey(new VerifyKey(data));
	}

	@Override
	public CryptoSharedKey createSharedKey(CryptoPublicKey publicKey, CryptoPrivateKey privateKey) {
		return new JavaCryptoSharedKey(publicKey, privateKey);
	}

	@Override
	public CryptoKeyPair generateKeyPair() {
		KeyPair keyPair = new KeyPair();
		return new CryptoKeyPair(
				new JavaCryptoPrivateKey(keyPair.getPrivateKey()),
				new JavaCryptoPublicKey(keyPair.getPublicKey()));
	}

	@Override
	public byte[] generateNonce() {
		return new Random().randomBytes(NONCE_BYTES);
	}
}
