/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.packetstreams.javacrypto;

import java.util.Arrays;
import org.openzen.packetstreams.crypto.CryptoPrivateKey;
import org.openzen.packetstreams.crypto.CryptoPublicKey;
import org.openzen.packetstreams.crypto.CryptoSharedKey;
import org.openzen.saltpot.crypto.Box;

/**
 *
 * @author Hoofdgebruiker
 */
public class JavaCryptoSharedKey implements CryptoSharedKey {
	private final Box box;
	
	public JavaCryptoSharedKey(CryptoPublicKey publicKey, CryptoPrivateKey privateKey) {
		box = new Box(publicKey.encode(), privateKey.encode());
	}

	@Override
	public byte[] decrypt(byte[] nonce, byte[] message, int offset, int length) {
		byte[] copy = offset == 0 && length == message.length
				? message
				: Arrays.copyOfRange(message, offset, offset + length);
		return box.decrypt(nonce, copy);
	}

	@Override
	public byte[] encrypt(byte[] nonce, byte[] message, int offset, int length) {
		byte[] copy = offset == 0 && length == message.length
				? message
				: Arrays.copyOfRange(message, offset, offset + length);
		return box.encrypt(nonce, copy);
	}
}
