/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams;

import java.util.LinkedList;
import java.util.Queue;
import org.openzen.packetstreams.PacketStream;
import org.openzen.packetstreams.ServiceStream;

public abstract class BufferedServiceStream
implements ServiceStream {
    private final PacketStream target;
    private final Queue<byte[]> buffer = new LinkedList<byte[]>();

    public BufferedServiceStream(PacketStream target) {
        this.target = target;
    }

    public void send(byte[] packet) {
        this.buffer.add(packet);
        this.target.resume();
    }

    public void close() {
        this.target.close();
    }

    public void close(int reason, byte[] info) {
        this.target.close(reason, info);
    }

    @Override
    public byte[] next() {
        return this.buffer.poll();
    }
}

