/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp;

import java.util.TimerTask;
import org.openzen.packetstreams.io.BytesDataInput;
import org.openzen.packetstreams.io.BytesDataOutput;
import org.openzen.packetstreams.qpsp.QPSPSession;
import org.openzen.packetstreams.qpsp.QPSPStream;

public class ControlStream
extends QPSPStream {
    private PingTimerTask pingTimer = null;
    private int pingInterval = Integer.MAX_VALUE;

    public ControlStream(QPSPSession session, long localId, long remoteId) {
        super(session, localId, remoteId, null);
    }

    public void setPingInterval(int millis) {
        if (millis == this.pingInterval) {
            return;
        }
        this.pingInterval = millis;
        if (this.pingTimer != null) {
            this.pingTimer.cancel();
            this.pingTimer = null;
        }
        if (millis != Integer.MAX_VALUE) {
            this.pingTimer = new PingTimerTask();
            this.timer.scheduleAtFixedRate((TimerTask)this.pingTimer, millis, (long)millis);
        }
    }

    @Override
    public void handleUnknown(int type, BytesDataInput input) {
        switch (type) {
            case 16: {
                long remoteFromStreamId = input.readVarULong();
                long remoteToStreamId = remoteFromStreamId + (long)(2 * input.readVarUInt());
                int maxPacketSize = input.readVarUInt();
                int maxBufferSize = input.readVarUInt();
                this.logger.log(4, this.localId, "<- INITIALIZED");
                this.handleInitialized(remoteFromStreamId, remoteToStreamId, maxPacketSize, maxBufferSize);
                return;
            }
            case 17: {
                long timestampDelta = input.readVarULong();
                this.logger.log(4, this.localId, "<- PING");
                this.handlePing(timestampDelta);
                return;
            }
            case 18: {
                long clientTimestampDelta = input.readVarULong();
                long serverTimestampDelta = clientTimestampDelta + input.readVarLong();
                this.logger.log(4, this.localId, "<- PINGRESPONSE");
                this.handlePingResponse(clientTimestampDelta, serverTimestampDelta);
                return;
            }
        }
        super.handleUnknown(type, input);
    }

    private void handleInitialized(long remoteFromStreamId, long remoteToStreamId, int maxPacketSize, int maxBufferSize) {
        this.session.initialized(remoteFromStreamId, remoteToStreamId, maxPacketSize, maxBufferSize);
    }

    private void handlePing(long timestampDelta) {
        BytesDataOutput output = new BytesDataOutput();
        output.writeUByte(18);
        output.writeVarULong(timestampDelta);
        output.writeVarLong(System.currentTimeMillis() - timestampDelta);
        this.enqueueControlFrame(output.toByteArray());
        this.resume();
    }

    private void handlePingResponse(long clientTimestampDelta, long serverTimestampDelta) {
        int rtt = (int)(System.currentTimeMillis() - clientTimestampDelta);
        this.session.onPingReceived(rtt, serverTimestampDelta + (long)(rtt / 2));
    }

    public void initialize() {
        BytesDataOutput output = new BytesDataOutput();
        output.writeUByte(16);
        output.writeVarULong(this.session.localFromStreamID);
        output.writeVarUInt((int)(this.session.localToStreamID - this.session.localFromStreamID) / 2);
        output.writeVarUInt(this.session.maxPacketSize);
        output.writeVarUInt(this.session.maxBufferSize);
        this.enqueueControlFrame(output.toByteArray());
    }

    private void ping() {
        BytesDataOutput output = new BytesDataOutput();
        output.writeUByte(17);
        output.writeVarULong(System.currentTimeMillis());
        this.enqueueControlFrame(output.toByteArray());
        this.resume();
    }

    private class PingTimerTask
    extends TimerTask {
        private PingTimerTask() {
        }

        @Override
        public void run() {
            ControlStream.this.ping();
        }
    }
}

