/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import org.openzen.packetstreams.qpsp.PacketScheduler;
import org.openzen.packetstreams.qpsp.QPSPPacket;
import org.openzen.packetstreams.qpsp.QPSPSession;
import org.openzen.packetstreams.qpsp.StreamMultiplexer;

public class StandardPacketScheduler
implements PacketScheduler {
    private final QPSPSession session;
    private final StreamMultiplexer multiplexer;
    private final List<InFlightPacket> inFlight = new ArrayList<InFlightPacket>();
    private final Queue<QPSPPacket> retransmit = new LinkedList<QPSPPacket>();
    private final Timer timer = new Timer();
    private int latestRTT = 1000;
    private int srtt = 0;

    public StandardPacketScheduler(QPSPSession session, StreamMultiplexer multiplexer) {
        this.session = session;
        this.multiplexer = multiplexer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] next() {
        boolean isRetransmission;
        QPSPPacket next;
        Queue<QPSPPacket> queue = this.retransmit;
        synchronized (queue) {
            if (!this.retransmit.isEmpty()) {
                next = this.retransmit.poll();
                isRetransmission = true;
            } else {
                next = this.multiplexer.next();
                isRetransmission = false;
            }
        }
        if (next == null) {
            return null;
        }
        if (!next.isLossy()) {
            InFlightPacket packet = new InFlightPacket(next, isRetransmission);
            List<InFlightPacket> list = this.inFlight;
            synchronized (list) {
                this.inFlight.add(packet);
            }
            int timeout = this.getTransmissionTimeout();
            System.out.println("Timeout: " + timeout);
            this.timer.schedule((TimerTask)packet, timeout);
        }
        return next.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAcknowledged(long streamID, long seq) {
        Object toRemove;
        Collection<Object> collection = this.inFlight;
        synchronized (collection) {
            toRemove = this.findInFlight(streamID, seq);
            if (toRemove != null) {
                ((TimerTask)toRemove).cancel();
                this.inFlight.remove(toRemove);
                if (((InFlightPacket)toRemove).isRetransmission) {
                    this.session.logger.log(8, streamID, "Ack " + seq + ", retransmitted packet");
                } else {
                    int rtt = (int)(System.currentTimeMillis() - ((InFlightPacket)toRemove).packet.timestamp);
                    this.session.logger.log(8, streamID, "Ack " + seq + ", rtt = " + rtt);
                    this.latestRTT = rtt;
                    this.srtt = this.srtt == 0 ? rtt : (int)((float)this.srtt * 0.9f + (float)rtt * 0.1f);
                }
            }
        }
        collection = this.retransmit;
        synchronized (collection) {
            toRemove = this.findRetransmit(streamID, seq);
            this.retransmit.remove(toRemove);
        }
    }

    @Override
    public void onClosed(long streamID) {
    }

    private InFlightPacket findInFlight(long streamID, long seq) {
        for (InFlightPacket packet : this.inFlight) {
            if (((InFlightPacket)packet).packet.localStreamID != streamID || ((InFlightPacket)packet).packet.seq != seq) continue;
            return packet;
        }
        return null;
    }

    private QPSPPacket findRetransmit(long streamID, long seq) {
        for (QPSPPacket packet : this.retransmit) {
            if (packet.localStreamID != streamID || packet.seq != seq) continue;
            return packet;
        }
        return null;
    }

    private int getTransmissionTimeout() {
        return (int)((float)Math.max(this.srtt, this.latestRTT) * 1.5f);
    }

    private class InFlightPacket
    extends TimerTask {
        private final QPSPPacket packet;
        private final boolean isRetransmission;

        public InFlightPacket(QPSPPacket packet, boolean isRetransmission) {
            this.packet = packet;
            this.isRetransmission = isRetransmission;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ((StandardPacketScheduler)StandardPacketScheduler.this).session.logger.log(8, this.packet.localStreamID, "Retransmitting #" + this.packet.seq);
            Collection collection = StandardPacketScheduler.this.retransmit;
            synchronized (collection) {
                StandardPacketScheduler.this.retransmit.add(this.packet);
            }
            collection = StandardPacketScheduler.this.inFlight;
            synchronized (collection) {
                StandardPacketScheduler.this.inFlight.remove(this);
            }
            StandardPacketScheduler.this.session.doResume();
        }
    }
}

