/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp;

import java.util.Arrays;
import org.openzen.packetstreams.qpsp.QPSPPacket;
import org.openzen.packetstreams.qpsp.QPSPSession;
import org.openzen.packetstreams.qpsp.QPSPStream;

public class StreamMultiplexer {
    private final QPSPSession session;
    private QPSPStream[] activeStreams = new QPSPStream[4];
    private int activeStreamCount = 0;

    public StreamMultiplexer(QPSPSession session) {
        this.session = session;
    }

    public void onPriorityChanged(QPSPStream stream) {
        this.sort();
    }

    public synchronized void resume(QPSPStream stream) {
        int position = this.getInsertPosition(stream);
        if (position == -1) {
            return;
        }
        if (this.activeStreamCount == this.activeStreams.length) {
            this.activeStreams = Arrays.copyOf(this.activeStreams, this.activeStreams.length * 2);
        }
        for (int i = this.activeStreamCount; i > position; ++i) {
            this.activeStreams[i] = this.activeStreams[i - 1];
        }
        this.activeStreams[position] = stream;
        ++this.activeStreamCount;
        this.session.doResume();
    }

    private int getInsertPosition(QPSPStream stream) {
        if (this.activeStreamCount == 0) {
            return 0;
        }
        for (int i = 0; i < this.activeStreamCount; ++i) {
            if (this.activeStreams[i] == stream) {
                return -1;
            }
            if (this.activeStreams[i].getPriority() >= stream.getPriority()) continue;
            return i;
        }
        return this.activeStreamCount;
    }

    public synchronized QPSPPacket next() {
        QPSPPacket result = null;
        int tail = 0;
        for (int i = 0; i < this.activeStreamCount; ++i) {
            if (result != null) {
                if (i != tail) {
                    this.activeStreams[tail] = this.activeStreams[i];
                }
                ++tail;
                continue;
            }
            result = this.activeStreams[i].next();
            if (result == null) continue;
            ++tail;
        }
        this.activeStreamCount = tail;
        return result;
    }

    private void sort() {
        Arrays.sort(this.activeStreams, 0, this.activeStreamCount, (a, b) -> a.getPriority() - b.getPriority());
    }
}

