/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp.socket;

import java.io.IOException;
import java.net.DatagramPacket;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.openzen.packetstreams.qpsp.socket.UDPSocket;

public class BadNetworkSimulator
implements UDPSocket {
    private final UDPSocket actual;
    private final Random random = new Random();
    private final double lossRate;
    private final double duplicateProbability;
    private final int minDelay;
    private final int maxDelay;
    private final Timer timer = new Timer();

    public BadNetworkSimulator(UDPSocket actual, double lossRate, double duplicateProbability, int minDelay, int maxDelay) {
        this.actual = actual;
        this.lossRate = lossRate;
        this.duplicateProbability = duplicateProbability;
        this.minDelay = minDelay;
        this.maxDelay = maxDelay;
    }

    @Override
    public DatagramPacket receive() throws IOException {
        return this.actual.receive();
    }

    @Override
    public void send(DatagramPacket packet) throws IOException {
        if (this.random.nextDouble() < this.lossRate) {
            System.out.println("Dropped packet");
            return;
        }
        int count = 0;
        do {
            if (count > 0) {
                System.out.println("Duplicated packet");
            }
            int delay = this.minDelay + this.random.nextInt(this.maxDelay - this.minDelay);
            this.timer.schedule((TimerTask)new TransmissionTimerTask(packet), delay);
            ++count;
        } while (this.random.nextDouble() < this.duplicateProbability);
    }

    @Override
    public void close() {
        this.actual.close();
    }

    private class TransmissionTimerTask
    extends TimerTask {
        private final DatagramPacket packet;

        public TransmissionTimerTask(DatagramPacket packet) {
            this.packet = packet;
        }

        @Override
        public void run() {
            try {
                BadNetworkSimulator.this.actual.send(this.packet);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

