/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams;

import java.util.UUID;
import java.util.zip.CRC32;
import org.openzen.packetstreams.io.BytesDataOutput;

/**
 * Contains service metadata: service type UUID, connection flags and 
 * service-specific information.
 */
public class ServiceMeta {
	public final UUID uuid;
	public final int flags;
	public final byte[] serviceInfo;
	
	public ServiceMeta(UUID uuid, int flags, byte[] serviceInfo) {
		this.uuid = uuid;
		this.flags = flags;
		this.serviceInfo = serviceInfo;
	}
	
	public int checksum() {
		BytesDataOutput data = new BytesDataOutput();
		data.writeUUID(uuid);
		data.writeVarUInt(flags);
		data.writeByteArray(serviceInfo);
		
		CRC32 crc = new CRC32();
		crc.update(data.toByteArray());
		return (int)crc.getValue();
	}
}
