/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams.qpsp.frames;

import org.openzen.packetstreams.qpsp.QPSPStream;

public class FinishPacketFrame implements Frame {
	private final long seq;

	public FinishPacketFrame(long seq) {
		this.seq = seq;
	}
	
	@Override
	public boolean tryExecute(QPSPStream stream) {
		return stream.finishPacket(seq);
	}
}
