/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams.qpsp.frames;

import org.openzen.packetstreams.ServiceMeta;
import org.openzen.packetstreams.qpsp.QPSPStream;

public class ServiceInfoFrame implements Frame {
	public final ServiceMeta meta;
	
	public ServiceInfoFrame(ServiceMeta meta) {
		this.meta = meta;
	}

	@Override
	public boolean tryExecute(QPSPStream stream) {
		stream.deliverServiceInfo(meta);
		return true;
	}
}
