/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.crypto;

import org.openzen.packetstreams.crypto.CryptoProvider;
import org.openzen.packetstreams.crypto.CryptoVerifyKey;
import org.openzen.packetstreams.io.BytesDataInput;
import org.openzen.packetstreams.io.BytesDataOutput;

public class CertificateChainNode {
    public final String hostname;
    public final CryptoVerifyKey verifyKey;
    public final long validFrom;
    public final long validDuration;
    public final byte[] signature;

    public CertificateChainNode(String hostname, CryptoVerifyKey verifyKey, long validFrom, long validDuration, byte[] signature) {
        this.hostname = hostname;
        this.verifyKey = verifyKey;
        this.validFrom = validFrom;
        this.validDuration = validDuration;
        this.signature = signature;
    }

    public CertificateChainNode(CryptoProvider crypto, BytesDataInput input) {
        this.hostname = input.readString();
        this.verifyKey = crypto.decodeVerifyKey(input.readRawBytes(32));
        this.validFrom = input.readVarULong();
        this.validDuration = input.readVarULong();
        this.signature = input.readRawBytes(64);
    }

    public boolean validate(CertificateChainNode previous) {
        if (!previous.authorizes(this.hostname)) {
            return false;
        }
        if (this.validFrom < previous.validFrom || this.validFrom + this.validDuration > previous.validFrom + previous.validDuration) {
            return false;
        }
        BytesDataOutput output = new BytesDataOutput();
        output.writeString(this.hostname);
        output.writeRawBytes(this.verifyKey.encode());
        output.writeVarULong(this.validFrom);
        output.writeVarULong(this.validDuration);
        return this.verifyKey.verify(output.toByteArray(), this.signature);
    }

    public boolean authorizes(String domainName) {
        if (this.hostname.equals(domainName)) {
            return true;
        }
        if (this.hostname.equals("***")) {
            return true;
        }
        if (this.hostname.startsWith("**.")) {
            return domainName.endsWith(this.hostname.substring(2)) || domainName.equals(this.hostname.substring(3));
        }
        if (this.hostname.startsWith("*.")) {
            if (!domainName.endsWith(this.hostname.substring(1)) && !domainName.equals(this.hostname.substring(2))) {
                return false;
            }
            return domainName.indexOf(46) == domainName.length() - this.hostname.length() + 1;
        }
        return false;
    }

    public boolean isValid(String domainName, long time) {
        return this.authorizes(domainName) && time >= this.validFrom && time < this.validFrom + this.validDuration;
    }
}

