/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp.frames;

import java.util.Arrays;
import org.openzen.packetstreams.qpsp.QPSPStream;
import org.openzen.packetstreams.qpsp.frames.Frame;

public class FrameQueue {
    private final QPSPStream stream;
    private Frame[] frames = new Frame[16];
    private int length = 0;

    public FrameQueue(QPSPStream stream) {
        this.stream = stream;
    }

    public void offer(Frame frame) {
        if (frame.tryExecute(this.stream)) {
            this.resolve();
            return;
        }
        if (this.length == this.frames.length) {
            this.frames = Arrays.copyOf(this.frames, this.frames.length * 2);
        }
        this.frames[this.length++] = frame;
    }

    private void resolve() {
        boolean changed;
        do {
            if (this.length == 0) {
                return;
            }
            int tail = 0;
            changed = false;
            for (int head = 0; head < this.length; ++head) {
                if (this.frames[head].tryExecute(this.stream)) {
                    changed = true;
                    continue;
                }
                this.frames[tail] = this.frames[head];
                ++tail;
            }
            this.length = tail;
        } while (changed);
    }
}

