/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp;

import java.util.TimerTask;
import org.openzen.packetstreams.io.BytesDataInput;
import org.openzen.packetstreams.io.BytesDataOutput;
import org.openzen.packetstreams.qpsp.QPSPSession;
import org.openzen.packetstreams.qpsp.QPSPStream;

public class ControlStream
extends QPSPStream {
    private KeepaliveTimerTask keepaliveTimer = null;
    private int keepaliveInterval = 20000;
    private int maxKeepaliveInterval = 120000;
    private long lastKeepalive = System.currentTimeMillis();

    public ControlStream(QPSPSession session, long localId, long remoteId) {
        super(session, localId, remoteId, null);
        this.keepaliveTimer = new KeepaliveTimerTask();
        this.timer.scheduleAtFixedRate((TimerTask)this.keepaliveTimer, 1000L, 1000L);
    }

    @Override
    public void handleUnknown(int type, BytesDataInput input) {
        switch (type) {
            case 16: {
                long remoteFromStreamId = input.readVarULong();
                long remoteToStreamId = remoteFromStreamId + (long)(2 * input.readVarUInt());
                int maxPacketSize = input.readVarUInt();
                int maxBufferSize = input.readVarUInt();
                this.logger.log(4, this.localId, "<- INITIALIZED");
                this.handleInitialized(remoteFromStreamId, remoteToStreamId, maxPacketSize, maxBufferSize);
                return;
            }
            case 17: {
                this.logger.log(4, this.localId, "<- KEEPALIVE");
                long packetsReceived = input.readVarULong();
                return;
            }
        }
        super.handleUnknown(type, input);
    }

    @Override
    public int getPriority() {
        return 100;
    }

    private void handleInitialized(long remoteFromStreamId, long remoteToStreamId, int maxPacketSize, int maxBufferSize) {
        this.session.initialized(remoteFromStreamId, remoteToStreamId, maxPacketSize, maxBufferSize);
    }

    public void initialize(int keepaliveInterval, int maxKeepaliveInterval) {
        BytesDataOutput output = new BytesDataOutput();
        output.writeUByte(16);
        output.writeVarULong(this.session.localFromStreamID);
        output.writeVarUInt((int)(this.session.localToStreamID - this.session.localFromStreamID) / 2);
        output.writeVarUInt(this.session.maxPacketSize);
        output.writeVarUInt(this.session.maxBufferSize);
        this.enqueueControlFrame(output.toByteArray());
        this.keepaliveInterval = keepaliveInterval;
        this.maxKeepaliveInterval = maxKeepaliveInterval;
    }

    private class KeepaliveTimerTask
    extends TimerTask {
        private KeepaliveTimerTask() {
        }

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            if (now - ControlStream.this.session.getLastPacketSentTimestamp() < (long)ControlStream.this.keepaliveInterval && now - ControlStream.this.lastKeepalive < (long)ControlStream.this.maxKeepaliveInterval) {
                return;
            }
            ControlStream.this.lastKeepalive = now;
            BytesDataOutput output = new BytesDataOutput();
            output.writeVarUInt(17);
            output.writeVarULong(ControlStream.this.session.getTotalPacketsReceived());
            ControlStream.this.enqueueControlFrame(new QPSPStream.RawPacket(ControlStream.this, output.toByteArray(), true, true));
        }
    }
}

