/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams;

/**
 * Implements a host supporting a single server.
 */
public class SingleServerHost implements Host {
	private final String domainName;
	private final Server server;
	
	public SingleServerHost(String domainName, Server server) {
		this.domainName = domainName;
		this.server = server;
	}

	@Override
	public Server getServer(String name) {
		if (name.equals(domainName))
			return server;
		
		return null;
	}
}
