/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams.crypto;

/**
 * Shared keys are generated by combining a private key and public key from
 * two different endpoints.
 */
public interface CryptoSharedKey {
	public byte[] decrypt(byte[] nonce, byte[] message, int offset, int length) throws CryptoDecryptionException;
	
	public byte[] encrypt(byte[] nonce, byte[] message, int offset, int length);
}
