/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams.qpsp.frames;

import org.openzen.packetstreams.Service;
import org.openzen.packetstreams.qpsp.QPSPStream;

public class StartFrame implements Frame {
	private final int checksum;
	private final int priority;
	private final byte[] initData;
	
	public StartFrame(int checksum, int priority, byte[] initData) {
		this.checksum = checksum;
		this.priority = priority;
		this.initData = initData;
	}

	@Override
	public boolean tryExecute(QPSPStream stream) {
		Service service = stream.getService();
		if (service == null)
			return false; // OPEN or QUICKOPEN not yet received
		
		int calculatedChecksum = service.getMeta().checksum();
		if (checksum != calculatedChecksum) {
			stream.transmitServiceMeta();
		} else {
			stream.start(priority, initData);
		}
		return true;
	}
	
	
}
