/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.openzen.packetstreams.ClientSession;
import org.openzen.packetstreams.Server;
import org.openzen.packetstreams.Session;
import org.openzen.packetstreams.SigningRootValidator;
import org.openzen.packetstreams.crypto.CryptoDecryptionException;
import org.openzen.packetstreams.crypto.CryptoKeyPair;
import org.openzen.packetstreams.crypto.CryptoPrivateKey;
import org.openzen.packetstreams.crypto.CryptoPublicKey;
import org.openzen.packetstreams.crypto.CryptoSharedKey;
import org.openzen.packetstreams.crypto.CryptoVerifyKey;
import org.openzen.packetstreams.io.BytesDataInput;
import org.openzen.packetstreams.io.BytesDataOutput;
import org.openzen.packetstreams.qpsp.QPSPEndpoint;
import org.openzen.packetstreams.qpsp.QPSPSession;

public class QPSPClientSession
implements ClientSession {
    private final QPSPEndpoint endpoint;
    private final CryptoKeyPair keyPair;
    private final long clientNonce;
    public final String host;
    private final InetAddress address;
    private final int port;
    private final List<Consumer<Session>> whenEstablished = new ArrayList<Consumer<Session>>();
    private final Server server;
    private final SigningRootValidator rootValidator;
    private final int keepaliveInterval;
    private final int maxKeepaliveInterval;
    private boolean established = false;
    private long serverNonce;
    private CryptoPublicKey serverKey;
    private QPSPSession session;

    public QPSPClientSession(byte[] session, QPSPEndpoint endpoint, Server server, SigningRootValidator rootValidator, int keepaliveInterval, int maxKeepaliveInterval) throws IOException {
        this.endpoint = endpoint;
        this.server = server;
        this.rootValidator = rootValidator;
        this.keepaliveInterval = keepaliveInterval;
        this.maxKeepaliveInterval = maxKeepaliveInterval;
        BytesDataInput input = new BytesDataInput(session);
        CryptoPrivateKey privateKey = endpoint.crypto.decodePrivateKey(input.readByteArray());
        CryptoPublicKey publicKey = endpoint.crypto.decodePublicKey(input.readByteArray());
        this.keyPair = new CryptoKeyPair(privateKey, publicKey);
        this.serverKey = endpoint.crypto.decodePublicKey(input.readByteArray());
        this.clientNonce = input.readULong();
        this.serverNonce = input.readULong();
        this.host = input.readString();
        this.port = input.readVarUInt();
        long localFromStreamId = input.readVarULong();
        long localToStreamId = input.readVarULong();
        long remoteFromStreamId = input.readVarULong();
        long remoteToStreamId = input.readVarULong();
        long streamCounter = input.readVarULong();
        int maxPacketSize = input.readVarUInt();
        int maxBufferSize = input.readVarUInt();
        this.address = InetAddress.getByName(this.host);
        this.session = new QPSPSession(endpoint, this.address, this.port, localFromStreamId, localToStreamId, maxPacketSize, maxBufferSize, this.serverNonce, this.clientNonce, server, publicKey, this.keyPair);
        this.session.initFromStorage(streamCounter, remoteFromStreamId, remoteToStreamId);
        this.established = true;
    }

    public QPSPClientSession(QPSPEndpoint endpoint, Server local, String host, int port, CryptoKeyPair keyPair, long clientNonce, SigningRootValidator rootValidator, int keepaliveInterval, int maxKeepaliveInterval) throws UnknownHostException {
        this.host = host;
        this.port = port;
        this.endpoint = endpoint;
        this.keyPair = keyPair;
        this.clientNonce = clientNonce;
        this.server = local;
        this.address = InetAddress.getByName(host);
        this.rootValidator = rootValidator;
        this.keepaliveInterval = keepaliveInterval;
        this.maxKeepaliveInterval = maxKeepaliveInterval;
    }

    public void preInit(long serverNonce, CryptoPublicKey publicKey) {
        this.serverNonce = serverNonce;
        this.serverKey = publicKey;
    }

    public boolean isValidSigningRoot(CryptoVerifyKey rootKey) {
        return this.rootValidator.isValid(rootKey);
    }

    public QPSPSession init(long fromStreamId, long toStreamId, int maxPacketSize, int maxBufferSize) {
        this.established = true;
        QPSPSession result = new QPSPSession(this.endpoint, this.address, this.port, fromStreamId, toStreamId, maxPacketSize, maxBufferSize, this.serverNonce, this.clientNonce, this.server, this.serverKey, this.keyPair);
        result.init(fromStreamId, toStreamId, maxPacketSize, maxBufferSize, this.keepaliveInterval, this.maxKeepaliveInterval);
        for (Consumer<Session> listener : this.whenEstablished) {
            listener.accept(result);
        }
        return result;
    }

    @Override
    public void whenEstablished(Consumer<Session> listener) {
        this.whenEstablished.add(listener);
    }

    public byte[] decryptInit(byte[] init) throws CryptoDecryptionException {
        byte[] nonce = new byte[24];
        QPSPSession.setLong(nonce, 0, this.clientNonce);
        CryptoSharedKey sharedKey = this.endpoint.crypto.createSharedKey(this.serverKey, this.keyPair.privateKey);
        return sharedKey.decrypt(nonce, init, 0, init.length);
    }

    @Override
    public byte[] serialize() {
        if (!this.established) {
            return new byte[0];
        }
        BytesDataOutput output = new BytesDataOutput();
        output.writeByteArray(this.keyPair.privateKey.encode());
        output.writeByteArray(this.keyPair.publicKey.encode());
        output.writeByteArray(this.serverKey.encode());
        output.writeULong(this.clientNonce);
        output.writeULong(this.serverNonce);
        output.writeString(this.host);
        output.writeVarUInt(this.port);
        output.writeVarULong(this.session.localFromStreamID);
        output.writeVarULong(this.session.localToStreamID);
        output.writeVarULong(this.session.remoteFromStreamID);
        output.writeVarULong(this.session.remoteToStreamID);
        output.writeVarULong(this.session.getRemoteStreamCounter());
        return output.toByteArray();
    }
}

