/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.crypto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openzen.packetstreams.crypto.CertificateChainNode;
import org.openzen.packetstreams.crypto.CryptoProvider;
import org.openzen.packetstreams.crypto.CryptoPublicKey;
import org.openzen.packetstreams.crypto.CryptoSigningKey;
import org.openzen.packetstreams.crypto.CryptoVerifyKey;
import org.openzen.packetstreams.io.BytesDataInput;
import org.openzen.packetstreams.io.BytesDataOutput;

public class CertificateChain {
    public final CryptoVerifyKey rootKey;
    public final List<CertificateChainNode> path;
    public final byte[] signature;

    public CertificateChain(CryptoSigningKey rootSigningKey, CryptoPublicKey publicKey, String hostname) {
        this.rootKey = rootSigningKey.getVerifyKey();
        this.path = Collections.emptyList();
        BytesDataOutput output = new BytesDataOutput();
        output.writeString(hostname);
        output.writeRawBytes(publicKey.encode());
        this.signature = rootSigningKey.sign(output.toByteArray());
    }

    public CertificateChain(CryptoVerifyKey rootKey, List<CertificateChainNode> path, byte[] signature) {
        this.rootKey = rootKey;
        this.path = path;
        this.signature = signature;
    }

    public CertificateChain(CryptoProvider crypto, BytesDataInput input) {
        this.rootKey = crypto.decodeVerifyKey(input.readRawBytes(32));
        int pathLength = input.readVarUInt();
        this.path = new ArrayList<CertificateChainNode>();
        for (int i = 0; i < pathLength; ++i) {
            String domain = input.readString();
            CryptoVerifyKey verifyKey = crypto.decodeVerifyKey(input.readRawBytes(32));
            long validFrom = input.readVarULong();
            long validDuration = input.readVarULong();
            byte[] signature = input.readRawBytes(64);
            this.path.add(new CertificateChainNode(domain, verifyKey, validFrom, validDuration, signature));
        }
        this.signature = input.readRawBytes(64);
    }

    public boolean validate(String hostname, CryptoPublicKey serverPublicKey) {
        CertificateChainNode previous = new CertificateChainNode("***", this.rootKey, Long.MIN_VALUE, -1L, new byte[0]);
        for (CertificateChainNode node : this.path) {
            if (!node.validate(previous)) {
                return false;
            }
            previous = node;
        }
        if (!previous.isValid(hostname, System.currentTimeMillis())) {
            return false;
        }
        BytesDataOutput output = new BytesDataOutput();
        output.writeString(hostname);
        output.writeRawBytes(serverPublicKey.encode());
        return previous.verifyKey.verify(output.toByteArray(), this.signature);
    }

    public void serialize(BytesDataOutput output) {
        output.writeRawBytes(this.rootKey.encode());
        output.writeVarUInt(this.path.size());
        for (CertificateChainNode node : this.path) {
            output.writeString(node.hostname);
            output.writeRawBytes(node.verifyKey.encode());
            output.writeVarULong(node.validFrom);
            output.writeVarULong(node.validDuration);
            output.writeRawBytes(node.signature);
        }
        output.writeRawBytes(this.signature);
    }
}

