/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp.frames;

import org.openzen.packetstreams.Server;
import org.openzen.packetstreams.Service;
import org.openzen.packetstreams.qpsp.QPSPStream;
import org.openzen.packetstreams.qpsp.frames.Frame;

public class OpenFrame
implements Frame {
    private final long seq;
    private final String path;
    private final boolean emitServiceInfo;

    public OpenFrame(long seq, String path, boolean emitServiceInfo) {
        this.seq = seq;
        this.path = path;
        this.emitServiceInfo = emitServiceInfo;
    }

    @Override
    public boolean tryExecute(QPSPStream stream) {
        Server server = stream.getServer();
        Service service = server.getService(this.path);
        if (service == null) {
            stream.close(5, new byte[0]);
        } else {
            stream.setService(service);
        }
        if (this.emitServiceInfo) {
            stream.transmitServiceMeta();
        }
        return true;
    }
}

