/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams.io;

import java.time.LocalDate;
import java.util.UUID;

/**
 * Generic data input. Variant on the DataInputStream, but allows for more
 * compact encoding forms.
 */
public interface DataInput extends AutoCloseable
{
	public boolean readBoolean();
	
	public byte readSByte();
	
	public int readUByte();
	
	public short readShort();
	
	public int readUShort();
	
	public int readInt();
	
	public int readUInt();
	
	public long readLong();
	
	public long readULong();
	
	public int readVarInt();
	
	public int readVarUInt();
	
	public long readVarLong();
	
	public long readVarULong();
	
	public float readFloat();
	
	public double readDouble();
	
	public int readChar();
	
	public String readString();
	
	public byte[] readBytes();
	
	public byte[] readRawBytes(int length);
	
	public boolean[] readBoolArray();
	
	public byte[] readByteArray();
	
	public byte[] readUByteArray();
	
	public short[] readShortArray();
	
	public short[] readShortArray(int length);
	
	public short[] readUShortArray();
	
	public short[] readUShortArray(int length);
	
	public int[] readVarIntArray();
	
	public int[] readVarIntArray(int length);
	
	public int[] readVarUIntArray();
	
	public int[] readVarUIntArray(int length);
	
	public int[] readIntArray();
	
	public int[] readIntArray(int length);
	
	public int[] readUIntArray();
	
	public long[] readVarLongArray();
	
	public long[] readVarLongArray(int length);
	
	public long[] readVarULongArray();
	
	public long[] readVarULongArray(int length);
	
	public long[] readLongArray();
	
	public long[] readLongArray(int length);
	
	public long[] readULongArray();
	
	public long[] readULongArray(int length);
	
	public float[] readFloatArray();
	
	public float[] readFloatArray(int length);
	
	public double[] readDoubleArray();
	
	public double[] readDoubleArray(int length);
	
	public String[] readStringArray();
	
	public String[] readStringArray(int length);
	
	public LocalDate readDate();
	
	public UUID readUUID();
	
	public void skip(int bytes);
	
	public boolean hasMore();
	
	@Override
	public void close(); // no exception
}
