/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Logs all generated messages to System.out.
 */
public class ConsoleLogger implements NetworkLogger {
	private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
	
	private final String prefix;
	
	public ConsoleLogger(String prefix) {
		this.prefix = prefix;
	}

	@Override
	public void log(int category, long localStreamId, String message) {
		System.out.print(FORMAT.format(new Date()));
		if (localStreamId < 0) {
			System.out.println(" " + prefix + message);
		} else {
			System.out.println(" " + prefix + "#" + localStreamId + " " + message);
		}
	}
}
