/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams;

/**
 * Packet hints are communicate by the stream to the service to provide
 * information that can help with packet generation.
 */
public class PacketHints {
	/**
	 * If an implementation can choose the amount of data to be sent, use this
	 * amount. It helps to transmit the data into a single packet without
	 * fragmentation.
	 */
	public final int recommendedSize;
	
	public PacketHints(int recommendedSize) {
		this.recommendedSize = recommendedSize;
	}
}
