/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams.qpsp.frames;

import org.openzen.packetstreams.qpsp.QPSPStream;

public class DataFrame implements Frame {
	private final long seq;
	private final int dataseq;
	private final byte[] data;
	
	public DataFrame(long seq, int dataseq, byte[] data) {
		this.seq = seq;
		this.dataseq = dataseq;
		this.data = data;
	}

	@Override
	public boolean tryExecute(QPSPStream stream) {
		if (!stream.isStarted())
			return false;
		if (!stream.hasReached(seq, dataseq))
			return false;
		
		stream.deliver(seq, dataseq, data);
		return true;
	}
}
