/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams.qpsp.frames;

import java.util.Arrays;
import org.openzen.packetstreams.qpsp.QPSPStream;

public class FrameQueue {
	private final QPSPStream stream;
	
	private Frame[] frames = new Frame[16];
	private int length = 0;
	
	public FrameQueue(QPSPStream stream) {
		this.stream = stream;
	}
	
	public void offer(Frame frame) {
		if (frame.tryExecute(stream)) {
			resolve();
			return;
		}
		
		if (length == frames.length)
			frames = Arrays.copyOf(frames, frames.length * 2);
		
		frames[length++] = frame;
	}
	
	// Attempt to run blocked operations
	private void resolve() {
		boolean changed;
		do {
			if (length == 0)
				return;
			
			int head = 0;
			int tail = 0;
			changed = false;

			while (head < length) {
				if (frames[head].tryExecute(stream)) {
					changed = true;
				} else {
					frames[tail] = frames[head];
					tail++;
				}
				head++;
			}

			length = tail;
		} while (changed);
	}
}
