/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams.qpsp.socket;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.SocketException;

/**
 * Provides an UDP socket implementation. Switching out different
 * implementations may be used for testing purposes.
 */
public interface UDPSocket {
	void open() throws SocketException;
	
	void close();
	
	DatagramPacket receive() throws IOException;
	
	void send(DatagramPacket packet) throws IOException;
	
	int getTotalPacketsTransmitted();
	
	long getTotalDataTransmitted();
	
	int getTotalPacketsReceived();
	
	long getTotalDataReceived();
}
