/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp.frames;

import org.openzen.packetstreams.Service;
import org.openzen.packetstreams.qpsp.QPSPStream;
import org.openzen.packetstreams.qpsp.frames.Frame;

public class StartFrame
implements Frame {
    private final int checksum;
    private final int priority;
    private final byte[] initData;

    public StartFrame(int checksum, int priority, byte[] initData) {
        this.checksum = checksum;
        this.priority = priority;
        this.initData = initData;
    }

    @Override
    public boolean tryExecute(QPSPStream stream) {
        Service service = stream.getService();
        if (service == null) {
            return false;
        }
        int calculatedChecksum = service.getMeta().checksum();
        if (this.checksum != calculatedChecksum) {
            stream.transmitServiceMeta();
        } else {
            stream.start(this.priority, this.initData);
        }
        return true;
    }
}

