/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp.socket;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.SocketException;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.openzen.packetstreams.qpsp.socket.UDPSocket;

public class BadNetworkSimulator
implements UDPSocket {
    private static final int PACKET_OVERHEAD = 28;
    private final UDPSocket actual;
    private final Random random = new Random();
    private final double lossRate;
    private final double duplicateProbability;
    private final int minDelay;
    private final int maxDelay;
    private final int bytesPerSecond;
    private final int networkBuffer;
    private final Timer timer = new Timer();
    private int networkBufferSize = 0;
    private long networkBufferTime = System.currentTimeMillis();
    private boolean closed = true;
    private int packetsTransmitted = 0;
    private long bytesTransmitted = 0L;

    public BadNetworkSimulator(UDPSocket actual, double lossRate, double duplicateProbability, int minDelay, int maxDelay, int bytesPerSecond, int networkBuffer) {
        this.actual = actual;
        this.lossRate = lossRate;
        this.duplicateProbability = duplicateProbability;
        this.minDelay = minDelay;
        this.maxDelay = maxDelay;
        this.bytesPerSecond = bytesPerSecond;
        this.networkBuffer = networkBuffer + bytesPerSecond * (minDelay + maxDelay) / 1000;
    }

    @Override
    public void open() throws SocketException {
        this.closed = false;
        this.actual.open();
    }

    @Override
    public void close() {
        this.closed = true;
        this.actual.close();
    }

    @Override
    public DatagramPacket receive() throws IOException {
        return this.actual.receive();
    }

    @Override
    public void send(DatagramPacket packet) throws IOException {
        ++this.packetsTransmitted;
        this.bytesTransmitted += (long)packet.getLength();
        if (!this.tryToSendBytes(packet.getLength())) {
            System.out.println("Network overload, dropped packet");
            return;
        }
        if (this.random.nextDouble() < this.lossRate) {
            System.out.println("Dropped packet");
            return;
        }
        int count = 0;
        do {
            if (count > 0) {
                System.out.println("Duplicated packet");
            }
            int delay = 1000 * (packet.getLength() + 28) / this.bytesPerSecond + this.minDelay + this.random.nextInt(this.maxDelay - this.minDelay);
            this.timer.schedule((TimerTask)new TransmissionTimerTask(packet), delay);
            ++count;
        } while (this.random.nextDouble() < this.duplicateProbability);
    }

    @Override
    public int getTotalPacketsTransmitted() {
        return this.packetsTransmitted;
    }

    @Override
    public long getTotalDataTransmitted() {
        return this.bytesTransmitted;
    }

    @Override
    public int getTotalPacketsReceived() {
        return this.actual.getTotalPacketsReceived();
    }

    @Override
    public long getTotalDataReceived() {
        return this.actual.getTotalDataReceived();
    }

    private boolean tryToSendBytes(int bytes) {
        long now = System.currentTimeMillis();
        int millis = (int)(now - this.networkBufferTime);
        int bytesInFlight = Math.max(0, this.networkBufferSize - millis * this.bytesPerSecond / 1000);
        if (bytesInFlight + bytes > this.networkBuffer) {
            return false;
        }
        this.networkBufferSize = bytesInFlight + bytes;
        this.networkBufferTime = now;
        return true;
    }

    private class TransmissionTimerTask
    extends TimerTask {
        private final DatagramPacket packet;

        public TransmissionTimerTask(DatagramPacket packet) {
            this.packet = packet;
        }

        @Override
        public void run() {
            if (BadNetworkSimulator.this.closed) {
                return;
            }
            try {
                BadNetworkSimulator.this.actual.send(this.packet);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

