/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp.socket;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.openzen.packetstreams.qpsp.socket.UDPSocket;

public class PureUDPSocket
implements UDPSocket {
    private final int port;
    private final DatagramPacket buffer = new DatagramPacket(new byte[65536], 65536);
    private DatagramSocket socket = null;
    private int totalPacketsTransmitted = 0;
    private long totalDataTransmitted = 0L;
    private int totalPacketsReceived = 0;
    private long totalDataReceived = 0L;

    public PureUDPSocket() {
        this.port = -1;
    }

    public PureUDPSocket(int port) {
        this.port = port;
    }

    @Override
    public void open() throws SocketException {
        this.socket = this.port < 0 ? new DatagramSocket() : new DatagramSocket(this.port);
        this.socket.setSoTimeout(250);
    }

    @Override
    public DatagramPacket receive() throws IOException {
        if (this.socket == null) {
            throw new IOException("socket closed");
        }
        try {
            this.socket.receive(this.buffer);
        }
        catch (SocketTimeoutException ex) {
            return null;
        }
        ++this.totalPacketsReceived;
        this.totalDataReceived += (long)this.buffer.getLength();
        return this.buffer;
    }

    @Override
    public void send(DatagramPacket packet) throws IOException {
        if (this.socket == null) {
            return;
        }
        ++this.totalPacketsTransmitted;
        this.totalDataTransmitted += (long)packet.getLength();
        this.socket.send(packet);
    }

    @Override
    public void close() {
        if (this.socket == null) {
            return;
        }
        this.socket.close();
        this.socket = null;
    }

    @Override
    public int getTotalPacketsTransmitted() {
        return this.totalPacketsTransmitted;
    }

    @Override
    public long getTotalDataTransmitted() {
        return this.totalDataTransmitted;
    }

    @Override
    public int getTotalPacketsReceived() {
        return this.totalPacketsReceived;
    }

    @Override
    public long getTotalDataReceived() {
        return this.totalDataReceived;
    }
}

