/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams.qpsp.frames;

import org.openzen.packetstreams.qpsp.QPSPStream;

public class FragStartFrame implements Frame {
	private final long seq;
	private final int dataseq;
	private final byte[] data;
	
	public FragStartFrame(long seq, int dataseq, byte[] data) {
		this.seq = seq;
		this.dataseq = dataseq;
		this.data = data;
	}

	@Override
	public boolean tryExecute(QPSPStream stream) {
		if (!stream.hasReached(seq, dataseq))
			return false;
		
		stream.beginFragmented(data);
		return true;
	}
}
