/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp;

import java.util.Arrays;
import org.openzen.packetstreams.qpsp.QPSPPacket;
import org.openzen.packetstreams.qpsp.QPSPSession;
import org.openzen.packetstreams.qpsp.QPSPStream;

public class StreamMultiplexer {
    private final QPSPSession session;
    private QPSPStream[] activeStreams = new QPSPStream[4];
    private int activeStreamCount = 0;

    public StreamMultiplexer(QPSPSession session) {
        this.session = session;
    }

    public synchronized void onPriorityChanged(QPSPStream stream) {
        this.sort();
    }

    public int peekPriority() {
        return this.activeStreamCount == 0 ? Integer.MIN_VALUE : this.activeStreams[0].getPriority();
    }

    public synchronized void resume(QPSPStream stream) {
        int position = this.getInsertPosition(stream);
        if (position == -1) {
            return;
        }
        if (this.activeStreamCount == this.activeStreams.length) {
            this.activeStreams = Arrays.copyOf(this.activeStreams, this.activeStreams.length * 2);
        }
        for (int i = this.activeStreamCount; i > position; --i) {
            this.activeStreams[i] = this.activeStreams[i - 1];
        }
        this.activeStreams[position] = stream;
        ++this.activeStreamCount;
        this.session.doResume();
    }

    public String getActive() {
        StringBuilder active = new StringBuilder();
        for (int i = 0; i < this.activeStreamCount; ++i) {
            if (i > 0) {
                active.append(", ");
            }
            active.append(this.activeStreams[i].localId);
        }
        return active.toString();
    }

    private int getInsertPosition(QPSPStream stream) {
        if (this.activeStreamCount == 0) {
            return 0;
        }
        for (int i = 0; i < this.activeStreamCount; ++i) {
            if (this.activeStreams[i] == stream) {
                return -1;
            }
            if (stream.getPriority() <= this.activeStreams[i].getPriority()) continue;
            return i;
        }
        return this.activeStreamCount;
    }

    public synchronized QPSPPacket next() {
        QPSPPacket result = null;
        int removed = 0;
        for (int i = 0; i < this.activeStreamCount; ++i) {
            if (removed != 0) {
                this.activeStreams[i - removed] = this.activeStreams[i];
            }
            if (result != null || (result = this.activeStreams[i].next()) != null) continue;
            ++removed;
        }
        this.activeStreamCount -= removed;
        return result;
    }

    private void sort() {
        Arrays.sort(this.activeStreams, 0, this.activeStreamCount, (a, b) -> a.getPriority() - b.getPriority());
    }
}

