/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams.io;

import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.util.UUID;

/**
 * Generic data output. Variant on the DataOutputStream, but allows for more
 * compact encoding forms.
 */
public interface DataOutput extends AutoCloseable
{
	public void writeBoolean(boolean value);
	
	public void writeSByte(byte value);
	
	public void writeUByte(int value);
	
	public void writeShort(short value);
	
	public void writeUShort(int value);
	
	public void writeInt(int value);
	
	public void writeUInt(int value);
	
	public void writeLong(long value);
	
	public void writeULong(long value);
	
	public void writeVarInt(int value);
	
	public void writeVarUInt(int value);
	
	public void writeVarLong(long value);
	
	public void writeVarULong(long value);
	
    public void writeFloat(float value);
	
    public void writeDouble(double value);
	
	public void writeChar(int value);
	
    public void writeBytes(byte[] data);
	
	public void writeBytes(byte[] data, int offset, int length);
	
	public void writeAllBytes(ByteBuffer value);
	
	public void writeBytes(ByteBuffer value, int length);
	
	public void writeRawBytes(byte[] value);
	
	public void writeRawBytes(byte[] value, int offset, int length);
	
	public void writeRawBytes(ByteBuffer value, int length);
	
	public void writeByteArray(byte[] data);
	
	public void writeUByteArray(byte[] data);
	
	public void writeShortArray(short[] data);
	
	public void writeShortArrayRaw(short[] data);
	
	public void writeUShortArray(short[] data);
	
	public void writeUShortArrayRaw(short[] data);
	
	public void writeVarIntArray(int[] data);
	
	public void writeVarIntArrayRaw(int[] data);
	
	public void writeVarUIntArray(int[] data);
	
	public void writeVarUIntArrayRaw(int[] data);
	
	public void writeIntArray(int[] data);
	
	public void writeIntArrayRaw(int[] data);
	
	public void writeUIntArray(int[] data);
	
	public void writeUIntArrayRaw(int[] data);
	
	public void writeVarLongArray(long[] data);
	
	public void writeVarLongArrayRaw(long[] data);
	
	public void writeVarULongArray(long[] data);
	
	public void writeVarULongArrayRaw(long[] data);
	
	public void writeLongArray(long[] data);
	
	public void writeLongArrayRaw(long[] data);
	
	public void writeULongArray(long[] data);
	
	public void writeULongArrayRaw(long[] data);
	
	public void writeFloatArray(float[] data);
	
	public void writeFloatArrayRaw(float[] data);
	
	public void writeDoubleArray(double[] data);
	
	public void writeDoubleArrayRaw(double[] data);
	
	public void writeStringArray(String[] data);
	
	public void writeStringArrayRaw(String[] data);
	
    public void writeString(String str);
	
	public void writeDate(LocalDate value);
	
	public void writeUUID(UUID uuid);
	
	public void flush();
	
	@Override
	public void close(); // no exception
}
