/* MIT licensed - see LICENSE in the project root directory. */
package org.openzen.packetstreams;

import java.util.LinkedList;
import java.util.Queue;

/**
 * Buffered service streams will buffer packets to be transmitted. The buffer is
 * unbounded.
 */
public abstract class BufferedServiceStream implements ServiceStream {
	protected final PacketStream target;
	private final Queue<byte[]> buffer = new LinkedList<>();
	
	public BufferedServiceStream(PacketStream target) {
		this.target = target;
	}
	
	public void send(byte[] packet) {
		buffer.add(packet);
		target.resume();
	}
	
	public void close() {
		target.close();
	}
	
	public void close(int reason, byte[] info) {
		target.close(reason, info);
	}

	@Override
	public byte[] next(PacketHints hints) {
		return buffer.poll();
	}
}
