/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import org.openzen.packetstreams.ClientSession;
import org.openzen.packetstreams.EmptyHost;
import org.openzen.packetstreams.EmptyServer;
import org.openzen.packetstreams.Host;
import org.openzen.packetstreams.NetworkLogger;
import org.openzen.packetstreams.NullLogger;
import org.openzen.packetstreams.Server;
import org.openzen.packetstreams.SigningRootValidator;
import org.openzen.packetstreams.crypto.CertificateChain;
import org.openzen.packetstreams.crypto.CryptoDecryptionException;
import org.openzen.packetstreams.crypto.CryptoProvider;
import org.openzen.packetstreams.crypto.CryptoPublicKey;
import org.openzen.packetstreams.io.BytesDataInput;
import org.openzen.packetstreams.io.BytesDataOutput;
import org.openzen.packetstreams.qpsp.QPSPClientSession;
import org.openzen.packetstreams.qpsp.QPSPSession;
import org.openzen.packetstreams.qpsp.socket.PureUDPSocket;
import org.openzen.packetstreams.qpsp.socket.UDPSocket;

public class QPSPEndpoint {
    private static final int SETUP_TIMEOUT = 5000;
    public final CryptoProvider crypto;
    private final Host host;
    private final UDPSocket socket;
    public final NetworkLogger logger;
    private volatile boolean closed = false;
    private final Random random = new SecureRandom();
    private final TreeMap<Long, QPSPSession> sessionsByStream = new TreeMap();
    private final Map<SessionKey, QPSPSession> sessionsByRequest = new HashMap<SessionKey, QPSPSession>();
    private final Map<Long, QPSPClientSession> requestedSessions = new HashMap<Long, QPSPClientSession>();
    private final Timer setupRetransmitTimer = new Timer();
    private final List<SetupPacket> setups = new ArrayList<SetupPacket>();
    private long streamCounter = 4L + System.currentTimeMillis() % 100L * 4L;

    public QPSPEndpoint(UDPSocket socket, NetworkLogger logger, Host host, CryptoProvider crypto) {
        this.host = host;
        this.logger = logger;
        this.crypto = crypto;
        this.socket = socket;
    }

    public QPSPEndpoint(CryptoProvider crypto) {
        this(1200, EmptyHost.INSTANCE, crypto);
    }

    public QPSPEndpoint(Host host, CryptoProvider crypto) {
        this(1200, host, crypto);
    }

    public QPSPEndpoint(int port, CryptoProvider crypto) {
        this(port, EmptyHost.INSTANCE, crypto);
    }

    public QPSPEndpoint(int port, Host host, CryptoProvider crypto) {
        this(new PureUDPSocket(port), NullLogger.INSTANCE, host, crypto);
    }

    public void open() {
        try {
            this.socket.open();
            this.closed = false;
            new Receptor().start();
            for (QPSPSession session : this.sessionsByStream.values()) {
                session.resume();
            }
        }
        catch (SocketException ex) {
            this.logger.log(1, 0L, ex.getMessage());
        }
    }

    public void pause() {
        this.closed = true;
        for (QPSPSession session : this.sessionsByStream.values()) {
            session.pause();
        }
        this.socket.close();
    }

    public void close() {
        this.closed = true;
        for (QPSPSession session : this.sessionsByStream.values()) {
            session.close();
        }
        this.socket.close();
    }

    public ClientSession connect(String host, SigningRootValidator rootValidator) throws IOException {
        return this.connect(host, 1200, new EmptyServer(this.crypto.generateKeyPair()), rootValidator, 20000, 120000);
    }

    public ClientSession connect(String host, int port, Server local, SigningRootValidator rootValidator, int keepaliveInterval, int maxKeepaliveInterval) throws IOException {
        long clientNonce = this.random.nextLong();
        BytesDataOutput output = new BytesDataOutput();
        output.writeVarUInt(0);
        output.writeULong(clientNonce);
        output.writeVarUInt(1);
        output.writeVarUInt(0);
        output.writeString(host);
        output.writeRawBytes(local.getKeyPair().publicKey.encode());
        byte[] packetData = output.toByteArray();
        DatagramPacket packet = new DatagramPacket(packetData, packetData.length);
        packet.setAddress(InetAddress.getByName(host));
        packet.setPort(port);
        SetupPacket setup = new SetupPacket(packet, clientNonce);
        this.setups.add(setup);
        this.setupRetransmitTimer.scheduleAtFixedRate((TimerTask)setup, 5000L, 5000L);
        QPSPClientSession result = new QPSPClientSession(this, local, host, port, local.getKeyPair(), clientNonce, rootValidator, keepaliveInterval, maxKeepaliveInterval);
        this.requestedSessions.put(clientNonce, result);
        this.socket.send(packet);
        return result;
    }

    public long allocateStreams(int streams) {
        long result = this.streamCounter;
        this.streamCounter += (long)(streams * 4);
        return result;
    }

    public void send(QPSPSession channel, byte[] packetData) throws IOException {
        DatagramPacket packet = new DatagramPacket(packetData, packetData.length, channel.remoteAddress, channel.remotePort);
        this.socket.send(packet);
    }

    private void onReceived(DatagramPacket packet) throws IOException {
        byte[] data = Arrays.copyOfRange(packet.getData(), packet.getOffset(), packet.getLength());
        BytesDataInput input = new BytesDataInput(data);
        long stream = input.readVarULong();
        if (stream == 0L) {
            this.handleSetup(packet, input);
        } else if (stream == 1L) {
            this.handleInit(input);
        } else {
            Map.Entry<Long, QPSPSession> sessionEntry = this.sessionsByStream.floorEntry(stream);
            if (sessionEntry == null || stream >= sessionEntry.getValue().localToStreamID) {
                this.logger.log(2, stream, "No session found for this stream");
            } else {
                QPSPSession session = sessionEntry.getValue();
                session.onReceived(packet.getAddress(), packet.getPort(), stream, input);
            }
        }
    }

    private void handleSetup(DatagramPacket packet, BytesDataInput input) {
        long clientNonce = input.readULong();
        int protocolVersion = input.readVarUInt();
        if (protocolVersion != 1) {
            return;
        }
        int protocolFlags = input.readUByte();
        byte[] domainNameBytes = input.readBytes();
        String domainName = new String(domainNameBytes, StandardCharsets.UTF_8);
        byte[] clientPublicKey = input.readRawBytes(32);
        this.logger.log(1, 0L, "SETUP " + domainName);
        SessionKey key = new SessionKey(clientNonce, protocolVersion, protocolFlags, domainNameBytes, clientPublicKey);
        if (this.sessionsByRequest.containsKey(key)) {
            QPSPSession session = this.sessionsByRequest.get(key);
            session.setRemote(packet.getAddress(), packet.getPort());
            session.sendInit();
            return;
        }
        Server server = this.host.getServer(domainName);
        if (server == null) {
            return;
        }
        long fromStreamID = this.streamCounter;
        int streams = server.getSessionStreamCount();
        this.streamCounter += (long)(4 * streams);
        QPSPSession session = new QPSPSession(this, packet.getAddress(), packet.getPort(), fromStreamID, this.streamCounter, 1024, 4096, clientNonce, this.random.nextLong(), server, this.crypto.decodePublicKey(clientPublicKey), server.getKeyPair());
        this.sessionsByStream.put(session.localFromStreamID, session);
        this.sessionsByRequest.put(key, session);
        session.sendInit();
    }

    private void handleInit(BytesDataInput input) {
        QPSPClientSession session;
        this.logger.log(1, 1L, "INIT");
        long clientNonce = input.readULong();
        long serverNonce = input.readULong();
        int options = input.readVarUInt();
        CryptoPublicKey serverPublicKey = this.crypto.decodePublicKey(input.readRawBytes(32));
        TimerTask setup = null;
        for (SetupPacket packet : this.setups) {
            if (packet.nonce != clientNonce) continue;
            setup = packet;
        }
        if (setup != null) {
            setup.cancel();
            this.setups.remove(setup);
        }
        if ((session = this.requestedSessions.remove(clientNonce)) == null) {
            return;
        }
        session.preInit(serverNonce, serverPublicKey);
        try {
            byte[] decrypted = session.decryptInit(input.readByteArray());
            BytesDataInput decryptedInput = new BytesDataInput(decrypted);
            int flags = decryptedInput.readVarUInt();
            CertificateChain certificate = new CertificateChain(this.crypto, decryptedInput);
            long fromStreamId = decryptedInput.readVarULong();
            long toStreamId = fromStreamId + (long)decryptedInput.readVarUInt() * 4L;
            int maxPacketSize = decryptedInput.readVarUInt();
            int maxBufferSize = decryptedInput.readVarUInt();
            if (!session.isValidSigningRoot(certificate.rootKey)) {
                return;
            }
            if (!certificate.validate(session.host, serverPublicKey)) {
                return;
            }
            QPSPSession qpspSession = session.init(fromStreamId, toStreamId, maxPacketSize, maxBufferSize);
            this.sessionsByStream.put(qpspSession.localFromStreamID, qpspSession);
        }
        catch (CryptoDecryptionException ex) {
            this.logger.log(1, -1L, "Crypto exception on INIT packet");
            return;
        }
    }

    private static final class SessionKey {
        private final long clientNonce;
        private final int protocolVersion;
        private final int protocolFlags;
        private final byte[] domainName;
        private final byte[] clientPublicKey;

        public SessionKey(long clientNonce, int protocolVersion, int protocolFlags, byte[] domainName, byte[] clientPublicKey) {
            this.clientNonce = clientNonce;
            this.protocolVersion = protocolVersion;
            this.protocolFlags = protocolFlags;
            this.domainName = domainName;
            this.clientPublicKey = clientPublicKey;
        }

        public int hashCode() {
            int hash = 3;
            hash = 97 * hash + (int)(this.clientNonce ^ this.clientNonce >>> 32);
            hash = 97 * hash + this.protocolVersion;
            hash = 97 * hash + this.protocolFlags;
            hash = 97 * hash + Arrays.hashCode(this.domainName);
            hash = 97 * hash + Arrays.hashCode(this.clientPublicKey);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SessionKey other = (SessionKey)obj;
            return this.clientNonce == other.clientNonce && this.protocolVersion == other.protocolVersion && this.protocolFlags == other.protocolFlags && Arrays.equals(this.domainName, other.domainName) && Arrays.equals(this.clientPublicKey, other.clientPublicKey);
        }
    }

    private class Receptor
    extends Thread {
        private Receptor() {
        }

        @Override
        public void run() {
            try {
                while (!QPSPEndpoint.this.closed) {
                    DatagramPacket packet = QPSPEndpoint.this.socket.receive();
                    if (packet == null) continue;
                    QPSPEndpoint.this.onReceived(packet);
                }
            }
            catch (SocketException ex) {
                if (ex.getMessage().equals("socket closed")) {
                    return;
                }
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private class SetupPacket
    extends TimerTask {
        private final DatagramPacket packet;
        private final long nonce;

        public SetupPacket(DatagramPacket packet, long nonce) {
            this.packet = packet;
            this.nonce = nonce;
        }

        @Override
        public void run() {
            try {
                QPSPEndpoint.this.logger.log(8, 0L, "Retransmitting SETUP");
                QPSPEndpoint.this.socket.send(this.packet);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

